/******************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtKnx module.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
****************************************************************************/

#ifndef QKNXNETIPCONNECTREQUEST_H
#define QKNXNETIPCONNECTREQUEST_H

#include <QtKnx/qknxnetipcri.h>
#include <QtKnx/qknxnetipframe.h>
#include <QtKnx/qknxnetiphpai.h>
#include <QtKnx/qtknxglobal.h>

QT_BEGIN_NAMESPACE

class Q_KNX_EXPORT QKnxNetIpConnectRequestProxy final
{
public:
    QKnxNetIpConnectRequestProxy() = delete;
    ~QKnxNetIpConnectRequestProxy() = default;

    QKnxNetIpConnectRequestProxy(const QKnxNetIpFrame &&) = delete;
    explicit QKnxNetIpConnectRequestProxy(const QKnxNetIpFrame &frame);

    bool isValid() const;

    QKnxNetIpHpai controlEndpoint() const;
    QKnxNetIpHpai dataEndpoint() const;
    QKnxNetIpCri requestInformation() const;

    class Q_KNX_EXPORT Builder final
    {
    public:
        Builder &setControlEndpoint(const QKnxNetIpHpai &hpai);
        Builder &setDataEndpoint(const QKnxNetIpHpai &hpai);
        Builder &setRequestInformation(const QKnxNetIpCri &cri);

        QKnxNetIpFrame create() const;

    private:
        QKnxNetIpHpai m_ceHpai;
        QKnxNetIpHpai m_deHpai;
        QKnxNetIpCri m_cri;
    };
    static QKnxNetIpConnectRequestProxy::Builder builder();

private:
    const QKnxNetIpFrame &m_frame;
};

QT_END_NAMESPACE

#endif
